package fr.asip.cps3.exemple.modele.traitements.specifiques;

import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

import org.apache.log4j.Logger;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.jni.TraitementsSpecifiques;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.resultats.ResultatSpecifique;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;

/**
 * Classe de traitement spcifique: Recyclage du code porteur
 *
 */
public class RecyclageCodePorteur {

	/**
	 * Le loggeur
	 */
	private static Logger log = Logger.getLogger(RecyclageCodePorteur.class);	
	
	/**
	 * Renvoie le rsultat du traitement
	 * @return Rsultat du traitement
	 * @throws ExceptionTraitement 
	 */
	public static Resultat traitement(TraitementsSpecifiques traitementsSpecifiques) throws ExceptionTraitement {
		
		try {
			
			if(traitementsSpecifiques != null) {
		
				ResultatSpecifique resultat = new ResultatSpecifique("Recyclage du code porteur");
				
				try {
		
					// On essaie d'initialiser la librairie
					traitementsSpecifiques.initialiseLibrairie();
					
					// Traitement  tester
					traitementsSpecifiques.recyclageCodePorteur();
					
					// Formatage du rsultat
					resultat.setRetour("Carte recycle (0x00000000)");
					
				} catch (PKCS11Exception e) {

					log.info("Traitement echoue : "+TraitementsUtil.retranscritCodeRetour(e.getErrorCode()));
					resultat.setCodeRetour(e.getErrorCode());
					
				}
				
				return resultat;
				
			} else {
				
				// Si l'interface des traitements spcifiques est nulle il est impossible de raliser le traitement
				log.error("La librairie est nulle");
				throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_SPECIFIQUE_RECYCLAGE, "L'interface des traitements spcifiques est nulle");
				
			}

		} catch (Throwable t) {
			
			// Si une erreur Traitement a t rencontre on lve l'exception
			if(t instanceof ExceptionTraitement)
				throw (ExceptionTraitement)t;
			
			// Si une erreur inattendue est survenue on la logue et on la lve
			log.error("Une erreur inattendue est survenue : "+ExceptionProgrammeExemple.getStacktrace(t));
			throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_SPECIFIQUE_RECYCLAGE, "Une erreur inattendue est survenue");
			
		}

	}
	
}
